<?php
/*--------------------------------------------------------------
   properties_values_description.php 2023-04-19
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

/** @var DatabaseModel $this */
/** @var int $t_success */

$query = <<<SQL
INSERT INTO `properties_values_description`(`properties_values_id`, `language_id`, `values_name`, `description`)
SELECT
    `pv`.`properties_values_id`,
    `l`.`languages_id`,
    'unnamed value' AS `values_name`,
    '' AS `description`
FROM properties_values AS pv
LEFT JOIN `languages` l ON 1
LEFT JOIN `properties_values_description` pvd ON (`pv`.`properties_values_id` = `pvd`.`properties_values_id` AND `pvd`.`language_id` = `l`.`languages_id`)
WHERE `pvd`.`language_id` IS NULL
GROUP BY `pv`.`properties_values_id`, `l`.`languages_id`
ORDER BY `pv`.`properties_id`;
SQL;

$t_success &= is_numeric($this->query($query));
